/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import com.tiviacz.pizzacraft.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzacraft.blocks.PizzaBlock;
import com.tiviacz.pizzacraft.init.ModBlockEntityTypes;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.init.ModSounds;
import com.tiviacz.pizzacraft.items.PizzaPeelItem;
import com.tiviacz.pizzacraft.util.RenderUtils;
import com.tiviacz.pizzacraft.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RawPizzaBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = RawPizzaBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public RawPizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (level.m_7702_(pos) instanceof PizzaBlockEntity && ((PizzaBlockEntity)level.m_7702_(pos)).isBaking()) {
            if (rand.m_188500_() < 0.3) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)ModSounds.SIZZLING_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (rand.m_188503_(2) == 0) {
                double[] particlePos = RenderUtils.getPosRandomAboveBlockHorizontal(level, pos);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, particlePos[0], (double)pos.m_123342_() + 0.4, particlePos[1], 0.0, 0.025, 0.0);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (player.m_21120_(handIn).m_41720_() instanceof PizzaPeelItem && level.m_7702_(pos) instanceof PizzaBlockEntity) {
            ItemStack stack = this.m_5456_().m_7968_();
            ((PizzaBlockEntity)level.m_7702_(pos)).writeToItemStack(stack);
            if (!level.f_46443_) {
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
            }
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof PizzaBlockEntity) {
            return ((PizzaBlockEntity)blockEntity).onBlockActivated(player, handIn);
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (level.m_7702_(pos) instanceof PizzaBlockEntity && !player.m_7500_() && !(player.m_21205_().m_41720_() instanceof PizzaPeelItem)) {
            PizzaBlockEntity tileEntity = (PizzaBlockEntity)level.m_7702_(pos);
            for (int i = 0; i < tileEntity.getInventory().getSlots(); ++i) {
                if (tileEntity.getInventory().getStackInSlot(i).m_41619_()) continue;
                Utils.spawnItemStackInWorld(level, pos, tileEntity.getInventory().getStackInSlot(i));
            }
            Utils.spawnItemStackInWorld(level, pos, new ItemStack((ItemLike)ModItems.DOUGH.get()));
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof PizzaBlock)) {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (level.m_7702_(pos) instanceof PizzaBlockEntity && stack.m_41783_() != null) {
            ((PizzaBlockEntity)level.m_7702_(pos)).readFromStack(stack);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, BlockGetter level, BlockPos pos, Player player) {
        if (level.m_7702_(pos) instanceof PizzaBlockEntity) {
            ItemStack stack = this.m_7397_(level, pos, state);
            ((PizzaBlockEntity)level.m_7702_(pos)).writeToItemStack(stack);
            return stack;
        }
        return this.getCloneItemStack(state, result, level, pos, player);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return Utils.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.PIZZA.get(), PizzaBlockEntity::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PizzaBlockEntity(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        PizzaBlock.addInformationForPizza(stack, tooltip);
    }
}

